﻿using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using System.Linq;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class RegistrantDeploymentFactoryTests : DeploymentFactoryTestBase
    {
        [TestMethod]
        public void RDF_CreateDeployments_Should_Continue_To_Process_Deployments_If_There_Is_A_Null_Deployment_Location()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[2];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = CreateTwoDeploymentLocations(),
                    deploymentStartDate = DateTime.Parse("2005-11-01"),
                    deploymentEndDate = DateTime.Parse("2006-11-29")
                }
            };
            deployments[0] = depOne;
            Deployment deploymentWithNoLocations = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = null,
                    deploymentProjectCode = "9GF",
                    deploymentSegmentIdentifier = "1",
                    deploymentTerminationReason = "S"
                }
            };
            deployments[1] = deploymentWithNoLocations;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            Console.WriteLine("Factory Created");
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            Console.WriteLine("CreateDeployments has exited");
            Assert.IsNotNull(actual);
            Assert.AreEqual(2, actual.Count);

        }
        [TestMethod]
        public void RDF_CreateDeployments_Continues_To_Process_Deployments_If_There_Is_A_Null_Deployment()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[2];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = CreateTwoDeploymentLocations(),
                    deploymentStartDate = DateTime.Parse("2005-11-01"),
                    deploymentEndDate = DateTime.Parse("2006-11-29")
                }
            };
            deployments[0] = depOne;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
           // MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            Assert.IsNotNull(actual);
            Assert.AreEqual(2, actual.Count);

        }
        [TestMethod]
        public void RDF_CreateDeployments_CreateAdapter_Test()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[1];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = new DeploymentLocation[] 
                    {
                        CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30")
                    },
                    deploymentStartDate = DateTime.Parse("2005-11-01"),
                    deploymentEndDate = DateTime.Parse("2006-11-29")
                }
            };
            deployments[0] = depOne;
           
            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
           // MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            var dep = actual.First() as REGISTRANT_DEPLOYMENT;
            Assert.AreEqual("Kuwait", dep.DEPLOYMENT_COUNTRY);

        }
        [TestMethod]
        public void RDF_CreateDeployments_CreateAdapter_Service_Specific_Occupations()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[1];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = new DeploymentLocation[]
                    {
                         CreateDeploymentLocation("1J", "2010-12-26", "2010-12-31"),
                        CreateDeploymentLocation("1J", "2010-10-31", "2010-12-25"),
                        CreateDeploymentLocation("1J", "2010-09-01", "2010-10-25"),
                        CreateDeploymentLocation("1J", "2010-07-01", "2010-07-31"),
                        CreateDeploymentLocation("HK", "2010-02-15", "2010-04-30"),
                        CreateDeploymentLocation("HK", "2010-01-15", "2010-02-14"),
                        CreateDeploymentLocation("BA", "2009-01-20", "2009-09-06"),
                        CreateDeploymentLocation("KU", "2008-10-08", "2009-01-19")
                    },
                    deploymentStartDate = DateTime.Parse("2012-02-15"),
                    deploymentEndDate = DateTime.Parse("201-12-25")
                }
            };
            deployments[0] = depOne;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            var blah = actual.First() as REGISTRANT_DEPLOYMENT;
            Assert.AreEqual(1, blah.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Count);

        }

        [TestMethod]
        public void RDF_CreateDeployments_CreateAdapter_Has_MultipleOccupation_PerDeployment()
        {
            string sutEdipi = "6001010001";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[1];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = new DeploymentLocation[]
                    {
                         CreateDeploymentLocation("1J", "2014-05-26", "2014-12-31"),
                        CreateDeploymentLocation("1J", "2014-01-31", "2014-04-25"),
                        CreateDeploymentLocation("IZ", "2012-09-01", "2012-10-25"),
                        CreateDeploymentLocation("1J", "2012-07-01", "2012-07-31"),

                    },
                    deploymentStartDate = DateTime.Parse("2012-02-15"),
                    deploymentEndDate = DateTime.Parse("2014-12-25")
                }
            };
            deployments[0] = depOne;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            var blah = actual.First() as REGISTRANT_DEPLOYMENT;
            Assert.AreEqual(2, blah.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Count);
            Assert.AreEqual(2, blah.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Count);

        }

        [TestMethod]
        public void RDF_CreateDeployments_CreateAdapter_Service_Specific_Occupations_test3()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange("2003-01-01", "2017-05-05", "A");
            Deployment[] deployments = new Deployment[1];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = new DeploymentLocation[]
                    {
                        CreateDeploymentLocation("HK", "2010-02-15", "2010-08-30")
                    },
                    deploymentStartDate = DateTime.Parse("2010-02-15"),
                    deploymentEndDate = DateTime.Parse("2011-12-25")
                }
            };
            deployments[0] = depOne;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            var blah = actual.First() as REGISTRANT_DEPLOYMENT;
            Assert.AreEqual(3, blah.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Count);

        }

        [TestMethod]
        public void RDF_CreateDeployments_CreateAdapter_Service_Specific_Occupations_test2()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange("2003-01-01", "2017-05-05", "A");
            Deployment[] deployments = new Deployment[1];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = new DeploymentLocation[]
                    {
                        CreateDeploymentLocation("HK", "2008-02-15", "2009-10-30")
                    },
                    deploymentStartDate = DateTime.Parse("208-02-15"),
                    deploymentEndDate = DateTime.Parse("2011-12-25")
                }
            };
            deployments[0] = depOne;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            RegistrantDeploymentFactory factory = new RegistrantDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            var blah = actual.First() as REGISTRANT_DEPLOYMENT;
            Assert.AreEqual(1, blah.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Count);

        }
    }
}
